/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.cim.client.HSCLPARClientUtil;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCConsoleClient;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.client.HSCProfileClient;
import com.ibm.hsc.client.HSCSystemProfileClient;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscConstants;
import com.ibm.websm.diagnostics.IDebug;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class SystemConfigurationChange
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private static final String LIST_DELIMITER = ",";
    private static final String AFFINITY_PARTITION_TYPE = HMCCommandUtils.AFFINITY_PARTITION_TYPE;
    private static final String FRAME_TYPE = HMCCommandUtils.FRAME_TYPE;
    private static final String PARTITION_TYPE = HMCCommandUtils.PARTITION_TYPE;
    private static final String PROFILE_TYPE = HMCCommandUtils.PROFILE_TYPE;
    private static final String SYSTEM_TYPE = HMCCommandUtils.SYSTEM_TYPE;
    private static final String SYSTEM_PROFILE_TYPE = HMCCommandUtils.SYSTEM_PROFILE_TYPE;
    private HSCCECClient hcc = null;
    private HSCConsoleClient hcnc = null;
    private HSCLPARClient hlc = null;
    private HSCProfileClient hpc = null;
    private HSCSystemProfileClient hspc = null;
    private Hashtable inParams;
    private List sysProfPartitionsAddList;
    private List sysProfProfilesAddList;
    private List sysProfPartitionsDeleteList;
    private List sysProfProfilesDeleteList;
    private List sysProfPartitionList;
    private List sysProfProfileList;
    private List desiredIOList;
    private List desiredIOAddList;
    private List desiredIORemoveList;
    private List requiredIOList;
    private List requiredIOAddList;
    private List requiredIORemoveList;
    private List sniWindowList;
    private List sniWindowAddList;
    private List sniWindowRemoveList;
    private List sniDeviceIdList;
    private List sniDeviceIdAddList;
    private List sniDeviceIdRemoveList;
    private String attributes;
    private String cspSurveillance;
    private String defaultProfile;
    private String desiredCPU;
    private String desiredMEM;
    private String fileName;
    private String managedSystem;
    private String maximumCPU;
    private String maximumMEM;
    private String minimumCPU;
    private String minimumMEM;
    private String name;
    private String partitionName;
    private String partitionType;
    private String powerOffPolicy;
    private String profilePartitionName;
    private String profileName;
    private String resourceName;
    private String resourceType;
    private String realUser = System.getProperty("HMCRealUser.name");
    private String sniConfigMode;
    private String sniDeviceId;
    private String sniDeviceIdAdd;
    private String sniDeviceIdRemove;
    private String sniWindow;
    private String sniWindowAdd;
    private String sniWindowRemove;
    private String sysProfPartitionsAdd;
    private String sysProfProfilesAdd;
    private String sysProfPartitionsDelete;
    private String sysProfProfilesDelete;
    private String sysProfPartitionNames;
    private String sysProfProfileNames;
    private boolean powerOffBool = false;
    private int frameNumber;
    private short bootMode = (short)-2;
    private short serviceAuthority = (short)-1;
    private short sfpSurveillance = (short)-1;
    private short smallRMO = (short)-1;
    private boolean smallRMO_specified = false;
    private boolean writeStatus;
    private PrintStream output;

    public SystemConfigurationChange(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void initializeClients() throws HSCException {
        HSCClientObjectFactory hSCClientObjectFactory = null;
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string2, null);
        if (this.resourceType.equals(FRAME_TYPE)) {
            this.hcnc = hSCClientObjectFactory.createConsoleClient();
        } else if (this.resourceType.equals(SYSTEM_TYPE)) {
            try {
                this.hcc = hSCClientObjectFactory.createCECClient(this.resourceName, false);
            }
            catch (HSCException hSCException) {
                throw new HSCException(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND"));
            }
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(AFFINITY_PARTITION_TYPE)) {
            try {
                this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
            }
            catch (HSCException hSCException) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
            try {
                this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.resourceName, false);
            }
            catch (HSCException hSCException) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.resourceType.equals(PROFILE_TYPE)) {
            this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
            this.hlc = hSCClientObjectFactory.createLPARClient(this.managedSystem, this.partitionName, false);
            this.hpc = hSCClientObjectFactory.createProfileClient(this.managedSystem, this.partitionName, this.resourceName, false);
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
            if (null == this.hpc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "LPAR_PROFILE_NOT_FOUND");
                throw new HSCException(string);
            }
        } else if (this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            try {
                this.hcc = hSCClientObjectFactory.createCECClient(this.managedSystem, false);
                this.hspc = hSCClientObjectFactory.createSystemProfileClient(this.managedSystem, this.resourceName, false);
            }
            catch (HSCException hSCException) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "SYSTEM_PROFILE_NOT_FOUND");
                throw new HSCException(string);
            }
        }
    }

    private String getPropertiesChanged() {
        String string = "";
        Enumeration enumeration = this.inParams.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (null != this.inParams.get(string2)) {
                // empty if block
            }
            if (string2.equals("SNIConfigMode") && this.sniConfigMode == null || string2.equals("RMOSize") && !this.smallRMO_specified) continue;
            string = string + string2 + " ";
        }
        return string;
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object[] objectArray = null;
        string3 = HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")";
        string4 = HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")";
        string5 = HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.NAME_PARAM + ", " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ", and " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + "(" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")";
        if (null == this.resourceType || null == this.resourceName) {
            objectArray = new String[]{string3};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string3 + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (null == this.fileName && this.attributes == null) {
            string = "There were no attributes found. Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NO_ATTRIBUTES", string, objectArray);
            throw new HSCException(string2);
        }
        if (this.resourceType.equals(SYSTEM_TYPE) && null == this.resourceName) {
            objectArray = new String[]{string3};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string3 + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(SYSTEM_PROFILE_TYPE) && null == this.managedSystem) {
            objectArray = new String[]{string4};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string4 + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if ((this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(AFFINITY_PARTITION_TYPE)) && null == this.managedSystem) {
            objectArray = new String[]{string4};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string4 + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(PROFILE_TYPE) && (null == this.partitionName || null == this.managedSystem)) {
            objectArray = new String[]{string5};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + string5 + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException, HSCException {
        int n;
        int n2;
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Integer n3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object[] objectArray = null;
        int n4 = 0;
        if (!(this.resourceType == null || this.resourceType.equals(AFFINITY_PARTITION_TYPE) || this.resourceType.equals(FRAME_TYPE) || this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(PROFILE_TYPE) || this.resourceType.equals(SYSTEM_TYPE) || this.resourceType.equals(SYSTEM_PROFILE_TYPE))) {
            objectArray = new String[]{AFFINITY_PARTITION_TYPE + ", " + PARTITION_TYPE + ", " + PROFILE_TYPE + ", " + SYSTEM_TYPE + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + SYSTEM_PROFILE_TYPE};
            string = "There is an invalid resource type entered. The valid values are " + AFFINITY_PARTITION_TYPE + ", " + FRAME_TYPE + ", " + PARTITION_TYPE + ", " + PARTITION_TYPE + ", " + PROFILE_TYPE + ", " + SYSTEM_TYPE + ", and " + SYSTEM_PROFILE_TYPE + ". Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_INVALID_RESOURCE_TYPE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        boolean bl = this.resourceType.equals(FRAME_TYPE);
        if (!bl) {
            hashtable = this.hcc.getSystemData();
        }
        if ((this.sysProfPartitionsAdd != null || this.sysProfPartitionsDelete != null) && this.sysProfPartitionNames != null || (this.sysProfProfilesAdd != null || this.sysProfProfilesDelete != null) && this.sysProfProfileNames != null) {
            string = "There is an error with the partition profile fields. The += and -= operators cannot be used if the = operator is already in use. Please make changes and retry command";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_OPERATOR_COLLISION", string, null);
            throw new RequiredParameterException(string2);
        }
        if ((this.desiredIOAddList != null || this.desiredIORemoveList != null) && this.desiredIOList != null || (this.requiredIOAddList != null || this.requiredIORemoveList != null) && this.requiredIOList != null) {
            string = "There is an error with the I/O fields. The += and -= operators cannot be used if the = operator is already in use. Please make changes and retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_OPERATOR_COLLISION", string, null);
            throw new RequiredParameterException(string2);
        }
        if (this.sysProfPartitionList != null) {
            int n5 = 0;
            while (n5 < this.sysProfPartitionList.size()) {
                n4 = 0;
                string4 = (String)this.sysProfPartitionList.get(n5);
                int n6 = 0;
                while (n6 < this.sysProfPartitionList.size()) {
                    string3 = (String)this.sysProfPartitionList.get(n6);
                    if (string3.equals(string4) && ++n4 > 1) {
                        string = "The command entered contains identical partition names for the profile partition names. This is not permitted. Please check your entry and retry the command.";
                        string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SAME_PROFILE_PARTITION", string, null);
                        throw new RequiredParameterException(string2);
                    }
                    ++n6;
                }
                ++n5;
            }
        }
        if (this.resourceType.equals(PROFILE_TYPE)) {
            int n7;
            if (this.hlc.getPartitionType() > 1 && (this.desiredCPU != null || this.desiredMEM != null || this.minimumMEM != null || this.maximumMEM != null || this.minimumCPU != null || this.maximumCPU != null)) {
                objectArray = new String[]{HMCCommandUtils.DESIRED_CPU_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.MAXIMUM_CPU_ATTR};
                string = "An error occurred while attempting to create an affinity partition profile. The " + HMCCommandUtils.DESIRED_CPU_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", and " + HMCCommandUtils.MAXIMUM_CPU_ATTR + " are not valid attributes for creating" + " an affinity partition. Please retry this command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_ALPAR_ILLEGAL_ATTRIBUTES", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            hashtable2 = this.hpc.getProfileData();
            if (this.smallRMO != -1 && this.smallRMO != 1 && this.smallRMO != 2) {
                objectArray = new String[]{HMCCommandUtils.SMALL_RMO_ATTR, "1 and 2"};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SMALL_RMO_ATTR + " are " + 1 + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + 2 + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string);
            }
            if (this.smallRMO == -1) {
                n3 = (Integer)hashtable2.get("RMOSize");
                this.smallRMO = n3.shortValue();
            } else {
                this.smallRMO_specified = true;
            }
            Integer n8 = null;
            Integer n9 = null;
            Integer n10 = null;
            if (hashtable != null) {
                n9 = (Integer)hashtable.get("InstalledMemory");
                n8 = (Integer)hashtable.get("InstalledCPUCount");
                n10 = (Integer)hashtable.get("LmbSize");
            }
            n2 = 0;
            if (this.minimumCPU != null || this.maximumCPU != null) {
                n = 0;
                n7 = 0;
                n = this.maximumCPU != null ? Integer.parseInt(this.maximumCPU) : (Integer)hashtable2.get("MaximumCPUCount");
                if (n < (n7 = this.minimumCPU != null ? Integer.parseInt(this.minimumCPU) : (Integer)hashtable2.get("MinimumCPUCount"))) {
                    string = "The value of the minimum cpu setting must be less than the value of the maximum cpu setting. Please check your entry and retry the command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MIN_CPU_MUST_BE_LESS_THAN_MAX", string, null);
                    throw new RequiredParameterException(string2);
                }
            }
            if (this.minimumMEM != null || this.maximumMEM != null || this.desiredMEM != null) {
                n = 0;
                n7 = 0;
                int n11 = 0;
                n = this.maximumMEM != null ? Integer.parseInt(this.maximumMEM) : (Integer)hashtable2.get("MaximumMemoryMB");
                n7 = this.minimumMEM != null ? Integer.parseInt(this.minimumMEM) : (Integer)hashtable2.get("MinimumMemoryMB");
                if (this.desiredMEM != null) {
                    n11 = Integer.parseInt(this.desiredMEM);
                }
                if (n < n7) {
                    string = "The value of the minimum memory setting must be less than the value of the maximum memory setting. Please check your entry and retry the command";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MIN_MEM_MUST_BE_LESS_THAN_MAX", string, null);
                    throw new RequiredParameterException(string2);
                }
                int n12 = n10;
                if (n7 % n12 != 0 || n % n12 != 0 || n11 % n12 != 0) {
                    string = "The value of " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + " and " + HMCCommandUtils.DESIRED_MEM_ATTR + " must be a multiple of the logical memory block of the system (" + n12 + "). Please check your entry and retry the command.";
                    objectArray = new String[]{HMCCommandUtils.MINIMUM_MEM_ATTR, HMCCommandUtils.MAXIMUM_MEM_ATTR, HMCCommandUtils.DESIRED_MEM_ATTR};
                    objectArray[3] = n10.toString();
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MULTIPLE_OF_LMB", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
                if (1 == this.smallRMO && n / 64 < n7) {
                    objectArray = new String[]{HMCCommandUtils.MINIMUM_MEM_ATTR, HMCCommandUtils.MAXIMUM_MEM_ATTR};
                    string = "The value of the " + HMCCommandUtils.MAXIMUM_MEM_ATTR + " must be at least 64X the " + HMCCommandUtils.MINIMUM_MEM_ATTR + ". Please check your entry and retry the command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MIN_MEM_TOO_LOW", string, objectArray);
                    System.err.println(string2);
                }
            }
            if (this.maximumMEM != null || this.minimumMEM != null || this.desiredMEM != null || this.maximumCPU != null || this.minimumCPU != null || this.desiredCPU != null) {
                if (this.maximumMEM != null && n9 < Integer.parseInt(this.maximumMEM)) {
                    n2 = 1;
                }
                if (this.minimumMEM != null && n9 < Integer.parseInt(this.minimumMEM)) {
                    n2 = 1;
                }
                if (this.desiredMEM != null && n9 < Integer.parseInt(this.desiredMEM)) {
                    n2 = 1;
                }
                if (this.maximumCPU != null && n8 < Integer.parseInt(this.maximumCPU)) {
                    n2 = 1;
                }
                if (this.minimumCPU != null && n8 < Integer.parseInt(this.minimumCPU)) {
                    n2 = 1;
                }
                if (this.desiredCPU != null && n8 < Integer.parseInt(this.desiredCPU)) {
                    n2 = 1;
                }
                if (n2 != 0) {
                    objectArray = new String[]{HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.DESIRED_CPU_ATTR};
                    string = "An error occurred while trying to perform this command. The " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", or " + HMCCommandUtils.DESIRED_CPU_ATTR + " exceeds the actual memory and processor count of the managed system." + " Please make the appropriate changes and retry command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MEM_CPU_EXCEEDS_CEC", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
            }
            if (this.sniConfigMode != null && (n = Integer.parseInt(this.sniConfigMode)) != 0 && n != 1) {
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SNI_CONFIG_MODE_ATTR + " are " + "1" + ". Please retry command.";
                objectArray = new String[]{HMCCommandUtils.SNI_CONFIG_MODE_ATTR, "1"};
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (this.bootMode == HMCCommandUtils.INVALID_BOOT_MODE) {
                objectArray = new String[]{HMCCommandUtils.BOOT_MODE_ATTR, HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + ", " + HMCCommandUtils.SMS_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.STANDBY_BOOT_MODE_STR};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.BOOT_MODE_ATTR + " are " + HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + ", " + HMCCommandUtils.SMS_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", and " + HMCCommandUtils.STANDBY_BOOT_MODE_STR + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (this.serviceAuthority != -1 && this.serviceAuthority != HMCCommandUtils.SERVICE_AUTHORITY_OFF && this.serviceAuthority != HMCCommandUtils.SERVICE_AUTHORITY_ON) {
                objectArray = new String[]{HMCCommandUtils.SERVICE_AUTHORITY_ATTR, HMCCommandUtils.SERVICE_AUTHORITY_OFF + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SERVICE_AUTHORITY_ON};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SERVICE_AUTHORITY_ATTR + " are " + HMCCommandUtils.SERVICE_AUTHORITY_OFF + " and " + HMCCommandUtils.SERVICE_AUTHORITY_ON + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (this.sfpSurveillance != -1 && this.sfpSurveillance != HMCCommandUtils.SFP_SURVEILLANCE_OFF && this.sfpSurveillance != HMCCommandUtils.SFP_SURVEILLANCE_ON) {
                objectArray = new String[]{HMCCommandUtils.SFP_SURVEILLANCE_ATTR, HMCCommandUtils.SFP_SURVEILLANCE_OFF + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SFP_SURVEILLANCE_ON};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SFP_SURVEILLANCE_ATTR + " are " + HMCCommandUtils.SFP_SURVEILLANCE_OFF + " and " + HMCCommandUtils.SFP_SURVEILLANCE_ON + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string);
            }
        }
        if (this.name != null && this.name.length() > 31) {
            objectArray = new String[]{HMCCommandUtils.NAME_ATTR};
            string = "The value " + HMCCommandUtils.NAME_ATTR + " cannot be larger than 31 characters" + ". Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NAME_MORE_THAN_31_CHAR", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        int n13 = -1;
        short s = -1;
        if (hashtable != null) {
            n13 = ((Integer)hashtable.get("State")).shortValue();
            s = ((Integer)hashtable.get("Mode")).shortValue();
        }
        if ((this.resourceType.equals(AFFINITY_PARTITION_TYPE) || this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(PROFILE_TYPE)) && (n13 == 3 || n13 == 6 || n13 == 251 || s == HscConstants.SMP_MODE.shortValue())) {
            string = "The resource cannot be changed because the managed system is in initializing state, no power state, recovery state, or SMP mode. Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_CANNOT_PERFORM_CEC_STATE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(PROFILE_TYPE)) {
            boolean bl2 = false;
            if (this.requiredIOList != null && this.desiredIOList != null) {
                n2 = 0;
                while (n2 < this.requiredIOList.size()) {
                    string6 = (String)this.requiredIOList.get(n2);
                    n = 0;
                    while (n < this.desiredIOList.size()) {
                        string5 = (String)this.desiredIOList.get(n);
                        if (this.requiredIOList.equals(this.desiredIOList)) {
                            bl2 = true;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            if (this.requiredIOAddList != null && this.desiredIOAddList != null) {
                n2 = 0;
                while (n2 < this.requiredIOAddList.size()) {
                    string6 = (String)this.requiredIOAddList.get(n2);
                    n = 0;
                    while (n < this.desiredIOAddList.size()) {
                        string5 = (String)this.desiredIOAddList.get(n);
                        if (string6.equals(string5)) {
                            bl2 = true;
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
            if (bl2) {
                string = "There cannot be matching required I/O resources or desired I/O resources  added or changed in the partition or profile. Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYS_PROF_IO_MATCHING", string, null);
                throw new RequiredParameterException(string2);
            }
            if (null != this.maximumMEM && null != this.minimumMEM) {
                long l = Long.parseLong(this.maximumMEM);
                long l2 = Long.parseLong(this.minimumMEM);
                if (!HSCLPARClientUtil.validateRMOValues(this.smallRMO, l2, l)) {
                    objectArray = new String[]{HSCLPARClientUtil.MB_256 + "MB - " + HSCLPARClientUtil.GB_4 + "MB,  " + HSCLPARClientUtil.GB_1 + "MB - " + HSCLPARClientUtil.GB_16 + "MB,  " + HSCLPARClientUtil.GB_16 + "MB - " + HSCLPARClientUtil.GB_256 + "MB, " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HSCLPARClientUtil.GB_256 + "MB - " + HSCLPARClientUtil.TB_4 + "MB"};
                    string = "An error occurred when trying to perform this command. Since small RMO is not used, both the minimum and maximum memory settings must be within one of these ranges:" + HSCLPARClientUtil.MB_256 + "MB - " + HSCLPARClientUtil.GB_4 + "MB,  " + HSCLPARClientUtil.GB_1 + "MB - " + HSCLPARClientUtil.GB_16 + "MB,  " + HSCLPARClientUtil.GB_16 + "MB - " + HSCLPARClientUtil.GB_256 + "MB, and " + HSCLPARClientUtil.GB_256 + "MB - " + HSCLPARClientUtil.TB_4 + "MB" + ". Please retry command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_RMO_RANGE", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
            }
            if (this.sniWindowList != null) {
                this.validateSNIWindow(this.sniWindowList);
            }
            if (this.sniWindowAddList != null) {
                this.validateSNIWindow(this.sniWindowAddList);
            }
            if (this.sniWindowRemoveList != null) {
                this.validateSNIWindow(this.sniWindowRemoveList);
            }
        }
    }

    private void validateSNIWindow(List list) throws RequiredParameterException {
        String string = null;
        String string2 = null;
        Integer n = null;
        Integer n2 = null;
        int n3 = 0;
        while (n3 < list.size()) {
            n = (Integer)list.get(n3);
            n2 = (Integer)list.get(n3 + 1);
            if (n.intValue() != n2.intValue()) {
                string = "An error ocured when trying to perform this command.The sni_windows parameter contains a number of pairs of window values.Each pair should have matching values. One of these pairs do notmatch. Please make changes and retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SNI_WINDOWS_NOT_MATCH", string, null);
                throw new RequiredParameterException(string2);
            }
            n3 += 2;
        }
    }

    private Hashtable buildInputParams() throws HSCException {
        Object var1_1 = null;
        Integer n = null;
        Object var3_3 = null;
        Object var4_4 = null;
        this.inParams = new Hashtable();
        if (this.partitionType != null) {
            this.inParams.put("PartitionType", this.partitionType);
        }
        if (this.bootMode != -2) {
            this.inParams.put("BootMode", new Integer(this.bootMode));
        }
        if (this.smallRMO != -1) {
            this.inParams.put("RMOSize", new Integer(this.smallRMO));
        }
        if (this.serviceAuthority != -1) {
            this.inParams.put("ServiceAuthority", new Integer(this.serviceAuthority));
        }
        if (this.sfpSurveillance != -1) {
            this.inParams.put("SFPSurveillance", new Integer(this.sfpSurveillance));
        }
        if (this.requiredIOList != null) {
            this.inParams.put("Required_IO", this.requiredIOList);
        }
        if (this.requiredIOAddList != null) {
            this.inParams.put("RequiredIOAdd", this.requiredIOAddList);
        }
        if (this.requiredIORemoveList != null) {
            this.inParams.put("RequiredIORemove", this.requiredIORemoveList);
        }
        if (this.desiredIOList != null) {
            this.inParams.put("Desired_IO", this.desiredIOList);
        }
        if (this.desiredIOAddList != null) {
            this.inParams.put("DesiredIOAdd", this.desiredIOAddList);
        }
        if (this.desiredIORemoveList != null) {
            this.inParams.put("DesiredIORemove", this.desiredIORemoveList);
        }
        if (this.name != null) {
            this.inParams.put("UserDefinedName", this.name);
        }
        if (this.desiredCPU != null) {
            n = new Integer(this.desiredCPU);
            this.inParams.put("DesiredCPUCount", n);
        }
        if (this.maximumCPU != null) {
            n = new Integer(this.maximumCPU);
            this.inParams.put("MaximumCPUCount", n);
        }
        if (this.minimumCPU != null) {
            n = new Integer(this.minimumCPU);
            this.inParams.put("MinimumCPUCount", n);
        }
        if (this.desiredMEM != null) {
            n = new Integer(this.desiredMEM);
            this.inParams.put("DesiredMemoryMB", n);
        }
        if (this.maximumMEM != null) {
            n = new Integer(this.maximumMEM);
            this.inParams.put("MaximumMemoryMB", n);
        }
        if (this.minimumMEM != null) {
            n = new Integer(this.minimumMEM);
            this.inParams.put("MinimumMemoryMB", n);
        }
        if (this.defaultProfile != null) {
            this.inParams.put("DefaultProfileName", this.defaultProfile);
        }
        if (this.profileName != null) {
            this.inParams.put("ProfileName", this.profileName);
        }
        if (this.profilePartitionName != null) {
            this.inParams.put("PartitionName", this.profilePartitionName);
        }
        if (this.sniConfigMode != null) {
            this.inParams.put("SNIConfigMode", new Integer(this.sniConfigMode));
        }
        if (this.sniDeviceIdList != null) {
            this.inParams.put("SNIDeviceID", this.sniDeviceIdList);
        }
        if (this.sniDeviceIdAddList != null) {
            this.inParams.put("SNIDeviceIDAdd", this.sniDeviceIdAddList);
        }
        if (this.sniDeviceIdRemoveList != null) {
            this.inParams.put("SNIDeviceIDRemove", this.sniDeviceIdRemoveList);
        }
        if (this.sniWindowList != null) {
            this.inParams.put("SNIWindows", this.sniWindowList);
        }
        if (this.sniWindowAddList != null) {
            this.inParams.put("SNIWindowsAdd", this.sniWindowAddList);
        }
        if (this.sniWindowRemoveList != null) {
            this.inParams.put("SNIWindowsRemove", this.sniWindowRemoveList);
        }
        if (this.sysProfPartitionsAdd != null) {
            this.inParams.put("SysProfPartitionsAdd", this.sysProfPartitionsAddList);
        }
        if (this.sysProfPartitionsDelete != null) {
            this.inParams.put("SysProfPartitionsDelete", this.sysProfPartitionsDeleteList);
        }
        if (this.sysProfProfilesAdd != null) {
            this.inParams.put("SysProfProfilesAdd", this.sysProfProfilesAddList);
        }
        if (this.sysProfProfilesDelete != null) {
            this.inParams.put("SysProfProfilesDelete", this.sysProfProfilesDeleteList);
        }
        if (this.sysProfPartitionList != null) {
            this.inParams.put("SysProfPartitionList", this.sysProfPartitionList);
        }
        if (this.sysProfProfileList != null) {
            this.inParams.put("SysProfProfileList", this.sysProfProfileList);
        }
        if (this.cspSurveillance != null) {
            this.inParams.put("CspSurveillancePolicy", new Integer(this.cspSurveillance));
        }
        if (this.powerOffPolicy != null) {
            this.inParams.put("PowerOffPolicy", new Boolean(this.powerOffBool));
        }
        return this.inParams;
    }

    private void doChangeFrame() throws HSCException {
        this.hcnc.setFrameNumber(this.resourceName, this.frameNumber);
        String string = this.getPropertiesChanged();
        String[] stringArray = new String[]{string, this.name};
        String string2 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), string, this.resourceName);
        HSCLogUtils.logSystemEvent((short)2115, string2, stringArray, this.realUser);
    }

    private void doChangeSystem() throws HSCException {
        this.hcc.changeSystem(this.inParams);
        String string = this.getPropertiesChanged();
        String[] stringArray = new String[2];
        String string2 = this.hcc.getUserDefinedName();
        stringArray[0] = string;
        stringArray[1] = string2;
        String string3 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), string, string2);
        HSCLogUtils.logSystemEvent((short)2044, string3, stringArray, this.realUser);
    }

    private void doChangePartition() throws HSCException {
        this.hlc.changePartition(this.inParams);
        String string = this.getPropertiesChanged();
        String[] stringArray = new String[2];
        String string2 = this.hlc.getUserDefinedName();
        stringArray[0] = string;
        stringArray[1] = string2;
        String string3 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), string, string2);
        HSCLogUtils.logSystemEvent((short)2046, string3, stringArray, this.realUser);
    }

    private void doChangeAffinityPartition() throws HSCException {
        this.hlc.changePartition(this.inParams);
        String string = this.getPropertiesChanged();
        String[] stringArray = new String[2];
        String string2 = this.hlc.getUserDefinedName();
        stringArray[0] = string;
        stringArray[1] = string2;
        String string3 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), string, string2);
        HSCLogUtils.logSystemEvent((short)2046, string3, stringArray, this.realUser);
    }

    private void doChangeLPARProfile() throws HSCException {
        this.hpc.changeProfile(this.inParams);
        String string = this.getPropertiesChanged();
        String[] stringArray = new String[]{string, this.resourceName};
        String string2 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), stringArray[0], stringArray[1]);
        HSCLogUtils.logSystemEvent((short)2048, string2, stringArray, this.realUser);
    }

    private void doChangeSystemProfile() throws HSCException {
        this.hspc.changeSystemProfile(this.inParams);
        String string = this.getPropertiesChanged();
        String[] stringArray = new String[2];
        String string2 = this.hspc.getUserDefinedName();
        stringArray[0] = string;
        stringArray[1] = this.resourceName;
        String string3 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), string, this.resourceName);
        HSCLogUtils.logSystemEvent((short)2050, string3, stringArray, this.realUser);
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.initializeClients();
        this.validateParameterValues();
        this.buildInputParams();
        if (this.resourceType.equals(AFFINITY_PARTITION_TYPE) || this.resourceType.equals(PARTITION_TYPE)) {
            this.doChangePartition();
        } else if (this.resourceType.equals(PROFILE_TYPE)) {
            this.doChangeLPARProfile();
        } else if (this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            this.doChangeSystemProfile();
        } else if (this.resourceType.equals(SYSTEM_TYPE)) {
            this.doChangeSystem();
        } else if (this.resourceType.equals(FRAME_TYPE)) {
            this.doChangeFrame();
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Hashtable hashtable = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var10_10 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        Object var18_18 = null;
        int n = 0;
        this.attributes = (String)hashMap.get(HMCCommandUtils.ATTRIBUTE_PARAM);
        this.fileName = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.partitionName = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        this.resourceName = (String)hashMap.get(HMCCommandUtils.NAME_PARAM);
        if (this.fileName != null) {
            hashtable = HMCCommandUtils.parseInputFile(this.fileName, false);
        } else if (this.attributes != null) {
            hashtable = HMCCommandUtils.parseAttributes(this.attributes);
        }
        if (this.attributes != null || this.fileName != null) {
            this.cspSurveillance = (String)hashtable.get(HMCCommandUtils.CSP_SURVEILLANCE_POLICY_ATTR);
            this.defaultProfile = (String)hashtable.get(HMCCommandUtils.DEFAULT_PROFILE_ATTR);
            this.desiredCPU = (String)hashtable.get(HMCCommandUtils.DESIRED_CPU_ATTR);
            this.desiredMEM = (String)hashtable.get(HMCCommandUtils.DESIRED_MEM_ATTR);
            this.maximumCPU = (String)hashtable.get(HMCCommandUtils.MAXIMUM_CPU_ATTR);
            this.maximumMEM = (String)hashtable.get(HMCCommandUtils.MAXIMUM_MEM_ATTR);
            this.minimumCPU = (String)hashtable.get(HMCCommandUtils.MINIMUM_CPU_ATTR);
            this.minimumMEM = (String)hashtable.get(HMCCommandUtils.MINIMUM_MEM_ATTR);
            this.name = (String)hashtable.get(HMCCommandUtils.NAME_ATTR);
            this.partitionType = (String)hashtable.get(HMCCommandUtils.PARTITION_TYPE_ATTR);
            this.profileName = (String)hashtable.get(HMCCommandUtils.PROFILE_NAME_ATTR);
            this.profilePartitionName = (String)hashtable.get(HMCCommandUtils.PROFILE_PARTITION_NAME_ATTR);
            this.sniConfigMode = (String)hashtable.get(HMCCommandUtils.SNI_CONFIG_MODE_ATTR);
            this.sniDeviceId = (String)hashtable.get(HMCCommandUtils.SNI_DEVICE_ID_ATTR);
            this.sniDeviceIdAdd = (String)hashtable.get(HMCCommandUtils.SNI_DEVICE_ID_ATTR + "+");
            this.sniDeviceIdRemove = (String)hashtable.get(HMCCommandUtils.SNI_DEVICE_ID_ATTR + "-");
            this.sniWindow = (String)hashtable.get(HMCCommandUtils.SNI_WINDOW_ATTR);
            this.sniWindowAdd = (String)hashtable.get(HMCCommandUtils.SNI_WINDOW_ATTR + "+");
            this.sniWindowRemove = (String)hashtable.get(HMCCommandUtils.SNI_WINDOW_ATTR + "-");
            this.sysProfPartitionsAdd = (String)hashtable.get(HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR + "+");
            this.sysProfProfilesAdd = (String)hashtable.get(HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR + "+");
            this.sysProfPartitionsDelete = (String)hashtable.get(HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR + "-");
            this.sysProfProfilesDelete = (String)hashtable.get(HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR + "-");
            this.sysProfPartitionNames = (String)hashtable.get(HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR);
            this.sysProfProfileNames = (String)hashtable.get(HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR);
            string2 = (String)hashtable.get(HMCCommandUtils.DESIRED_IO_ATTR + "+");
            string3 = (String)hashtable.get(HMCCommandUtils.DESIRED_IO_ATTR + "-");
            string4 = (String)hashtable.get(HMCCommandUtils.DESIRED_IO_ATTR);
            string6 = (String)hashtable.get(HMCCommandUtils.REQUIRED_IO_ATTR);
            string7 = (String)hashtable.get(HMCCommandUtils.REQUIRED_IO_ATTR + "+");
            string8 = (String)hashtable.get(HMCCommandUtils.REQUIRED_IO_ATTR + "-");
            string5 = (String)hashtable.get(HMCCommandUtils.FRAME_NUMBER_ATTR);
            if (string5 != null) {
                this.frameNumber = Integer.parseInt(string5);
            }
            this.powerOffPolicy = (String)hashtable.get(HMCCommandUtils.POWER_OFF_POLICY_ATTR);
            if (this.powerOffPolicy != null) {
                if (this.powerOffPolicy.equals(HMCCommandUtils.POWER_OFF_POLICY_OFF)) {
                    this.powerOffBool = false;
                } else if (this.powerOffPolicy.equals(HMCCommandUtils.POWER_OFF_POLICY_ON)) {
                    this.powerOffBool = true;
                }
            }
            if ((string9 = (String)hashtable.get(HMCCommandUtils.SERVICE_AUTHORITY_ATTR)) != null) {
                this.serviceAuthority = Short.parseShort(string9);
            }
            if ((string10 = (String)hashtable.get(HMCCommandUtils.SFP_SURVEILLANCE_ATTR)) != null) {
                this.sfpSurveillance = Short.parseShort(string10);
            }
            if ((string11 = (String)hashtable.get(HMCCommandUtils.SMALL_RMO_ATTR)) != null) {
                this.smallRMO = Short.parseShort(string11);
            }
            if ((string = (String)hashtable.get(HMCCommandUtils.BOOT_MODE_ATTR)) != null) {
                this.bootMode = string.equals(HMCCommandUtils.NORMAL_BOOT_MODE_STR) ? HMCCommandUtils.NORMAL_BOOT_MODE : (string.equals(HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR) ? HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE : (string.equals(HMCCommandUtils.SMS_BOOT_MODE_STR) ? HMCCommandUtils.SMS_BOOT_MODE : (string.equals(HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR) ? HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE : (string.equals(HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR) ? HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE : (string.equals(HMCCommandUtils.STANDBY_BOOT_MODE_STR) ? HMCCommandUtils.STANDBY_BOOT_MODE : HMCCommandUtils.INVALID_BOOT_MODE)))));
            }
        }
        if (string4 != null) {
            this.desiredIOList = HMCCommandUtils.parseList(string4, LIST_DELIMITER);
        }
        if (string6 != null) {
            this.requiredIOList = HMCCommandUtils.parseList(string6, LIST_DELIMITER);
        }
        if (string2 != null) {
            this.desiredIOAddList = HMCCommandUtils.parseList(string2, LIST_DELIMITER);
        }
        if (string3 != null) {
            this.desiredIORemoveList = HMCCommandUtils.parseList(string3, LIST_DELIMITER);
        }
        if (string7 != null) {
            this.requiredIOAddList = HMCCommandUtils.parseList(string7, LIST_DELIMITER);
        }
        if (string8 != null) {
            this.requiredIORemoveList = HMCCommandUtils.parseList(string8, LIST_DELIMITER);
        }
        if (this.sniDeviceId != null) {
            this.sniDeviceIdList = HMCCommandUtils.mapStringToList(this.sniDeviceId);
        }
        if (this.sniDeviceIdAdd != null) {
            this.sniDeviceIdAddList = HMCCommandUtils.mapStringToList(this.sniDeviceIdAdd);
        }
        if (this.sniDeviceIdRemove != null) {
            this.sniDeviceIdRemoveList = HMCCommandUtils.mapStringToList(this.sniDeviceIdRemove);
        }
        if (this.sniWindow != null) {
            this.sniWindowList = HMCCommandUtils.mapIntegerToList(this.sniWindow);
        }
        if (this.sniWindowAdd != null) {
            this.sniWindowAddList = HMCCommandUtils.mapIntegerToList(this.sniWindowAdd);
        }
        if (this.sniWindowRemove != null) {
            this.sniWindowRemoveList = HMCCommandUtils.mapIntegerToList(this.sniWindowRemove);
        }
        if (this.sysProfPartitionNames != null) {
            this.sysProfPartitionList = HMCCommandUtils.parseList(this.sysProfPartitionNames, LIST_DELIMITER);
        }
        if (this.sysProfProfileNames != null) {
            this.sysProfProfileList = HMCCommandUtils.parseList(this.sysProfProfileNames, LIST_DELIMITER);
        }
        if (this.sysProfPartitionsAdd != null) {
            this.sysProfPartitionsAddList = HMCCommandUtils.parseList(this.sysProfPartitionsAdd, LIST_DELIMITER);
        }
        if (this.sysProfProfilesAdd != null) {
            this.sysProfProfilesAddList = HMCCommandUtils.parseList(this.sysProfProfilesAdd, LIST_DELIMITER);
        }
        if (this.sysProfPartitionsDelete != null) {
            this.sysProfPartitionsDeleteList = HMCCommandUtils.parseList(this.sysProfPartitionsDelete, LIST_DELIMITER);
        }
        if (this.sysProfProfilesDelete != null) {
            this.sysProfProfilesDeleteList = HMCCommandUtils.parseList(this.sysProfProfilesDelete, LIST_DELIMITER);
        }
        if (IDebug.enabled()) {
            System.out.println("Bootmode = " + this.bootMode);
            System.out.println("DesiredCPU = " + this.desiredCPU);
            System.out.println("DesiredMEM = " + this.desiredMEM);
            System.out.println("Name = " + this.name);
            System.out.println("Max CPU = " + this.maximumCPU);
            System.out.println("Max Mem = " + this.maximumMEM);
            System.out.println("Min CPU = " + this.minimumCPU);
            System.out.println("Min MEM = " + this.minimumMEM);
            System.out.println("ProfileName = " + this.profileName);
            System.out.println("ProfilePartitionName = " + this.profilePartitionName);
            System.out.println("serviceAuthority = " + this.serviceAuthority);
            System.out.println("sfp = " + this.sfpSurveillance);
            System.out.println("smallRMO = " + this.smallRMO);
            System.out.println("sniConfigMode = " + this.sniConfigMode);
            System.out.println("sniWindow = " + this.sniWindow);
            System.out.println("sniDeviceId = " + this.sniDeviceId);
            System.out.println("sysProfPartitionNames = " + this.sysProfPartitionNames);
            System.out.println("sysProfProfileNames = " + this.sysProfProfileNames);
            if (this.desiredIOList != null) {
                n = 0;
                while (n < this.desiredIOList.size()) {
                    System.out.println("DesiredIO[" + n + "] = " + this.desiredIOList.get(n));
                    ++n;
                }
            }
            if (this.requiredIOList != null) {
                n = 0;
                while (n < this.requiredIOList.size()) {
                    System.out.println("RequiredIO[" + n + "] = " + this.requiredIOList.get(n));
                    ++n;
                }
            }
            if (this.sniDeviceIdList != null) {
                n = 0;
                while (n < this.sniDeviceIdList.size()) {
                    System.out.println("sniDeviceIdList[" + n + "] = " + this.sniDeviceIdList.get(n));
                    ++n;
                }
            }
            if (this.sniDeviceIdAddList != null) {
                n = 0;
                while (n < this.sniDeviceIdAddList.size()) {
                    System.out.println("sniDeviceIdAddList[" + n + "] = " + this.sniDeviceIdAddList.get(n));
                    ++n;
                }
            }
            if (this.sniDeviceIdRemoveList != null) {
                n = 0;
                while (n < this.sniDeviceIdRemoveList.size()) {
                    System.out.println("sniDeviceIdRemoveList[" + n + "] = " + this.sniDeviceIdRemoveList.get(n));
                    ++n;
                }
            }
            if (this.sniWindowList != null) {
                n = 0;
                while (n < this.sniWindowList.size()) {
                    System.out.println("sniWindowList[" + n + "] = " + this.sniWindowList.get(n));
                    ++n;
                }
            }
            if (this.sniWindowAddList != null) {
                n = 0;
                while (n < this.sniWindowAddList.size()) {
                    System.out.println("sniWindowAddList[" + n + "] = " + this.sniWindowAddList.get(n));
                    ++n;
                }
            }
            if (this.sniWindowRemoveList != null) {
                n = 0;
                while (n < this.sniWindowRemoveList.size()) {
                    System.out.println("sniWindowRemoveList[" + n + "] = " + this.sniWindowRemoveList.get(n));
                    ++n;
                }
            }
            if (this.sysProfPartitionList != null) {
                n = 0;
                while (n < this.sysProfPartitionList.size()) {
                    System.out.println("sysProfPartitionList[" + n + "] = " + (String)this.sysProfPartitionList.get(n));
                    ++n;
                }
            }
            if (this.sysProfProfileList != null) {
                n = 0;
                while (n < this.sysProfProfileList.size()) {
                    System.out.println("sysProfProfile[" + n + "] = " + (String)this.sysProfProfileList.get(n));
                    ++n;
                }
            }
            if (this.sysProfPartitionsAddList != null) {
                n = 0;
                while (n < this.sysProfPartitionsAddList.size()) {
                    System.out.println("sysProfPartitionsAddList[" + n + "] = " + (String)this.sysProfPartitionsAddList.get(n));
                    ++n;
                }
            }
            if (this.sysProfPartitionsDeleteList != null) {
                n = 0;
                while (n < this.sysProfPartitionsDeleteList.size()) {
                    System.out.println("sysProfPartitionsDeleteList[" + n + "] = " + (String)this.sysProfPartitionsDeleteList.get(n));
                    ++n;
                }
            }
            if (this.sysProfProfilesAddList != null) {
                n = 0;
                while (n < this.sysProfProfilesAddList.size()) {
                    System.out.println("sysProfProfilesAddList[" + n + "] = " + (String)this.sysProfProfilesAddList.get(n));
                    ++n;
                }
            }
            if (this.sysProfProfilesDeleteList != null) {
                n = 0;
                while (n < this.sysProfProfilesDeleteList.size()) {
                    System.out.println("sysProfProfilesDeleteList[" + n + "] = " + (String)this.sysProfProfilesDeleteList.get(n));
                    ++n;
                }
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "CHANGE_SYSTEM_CONFIGURATION_HELP"));
    }

    public static void main(String[] stringArray) {
        SystemConfigurationChange systemConfigurationChange = new SystemConfigurationChange(true);
        int n = systemConfigurationChange.process(stringArray);
        System.exit(n);
    }

    public static void entryMethod(String[] stringArray) {
        SystemConfigurationChange systemConfigurationChange = new SystemConfigurationChange(false);
        systemConfigurationChange.process(stringArray);
    }

    private int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                hSCException.printStackTrace(this.output);
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace(this.output);
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                exception.printStackTrace(this.output);
            }
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }
}

